function [V_total, E_total] = hamiltonian_AState_hfs_v2(Fn_A, J_A, I, F_A)

% Finds mixing coefficients for the A state by solving the hamiltonian
% Fn_A --> F2/F1 manifold to which the state whose mixing is studied
% J_A  --> J quantum number of the state
% I    --> Nuclear spin quantum number (0 or 2)
% F_A  --> Hyperfine quantum number of the state

disp_flag = 1; % Flag for printing output


%% Constants

J_l = J_A;          % Initial state J number
F = F_A;            % Initial state F number

T = 12732.84033;    %[cm-1] - Taken from Wu07
B = 1.6973871;      %[cm-1] - Taken from Wu07
D = 5.9609e-6;      %[cm-1] - Taken from Wu07
A = -74.63428;      %[cm-1] - Taken from Wu07
AD= -7.142e-5;      %[cm-1] - Taken from Wu07
p = 5.118e-3;       %[cm-1] - Taken from Wu07
q = -3.3696e-4;     %[cm-1] - Taken from Wu07

% Wu07 - Y. D. Wu, J. W. Ben, B. Li, L. J. Zheng, Y. Q. Chen, and X. H. Yang.
%        Study of (2, 0)band ofA2Πu−X2Σ+gsystem of N+2by optical heterodyne detected
%        velocity modulationspectroscopy.Chinese J. Chem. Phys., 20:285, 2007

% p = 0;            %[cm-1] Use to turn off lambda doubling
% q = 0;            %[cm-1] Use to turn off lambda doubling


a = 66;             %[MHz] - Taken from Bruna08
b = 9;             %[MHz] - Taken from Bruna08
c = -35;            %[MHz] - Taken from Bruna08
d = 77;            %[MHz] - Taken from Bruna08

%Bruna08 - P. J. Bruna and F. Grein. TheA2Πustate of N+2:
%          Electric properties, fine and hyperfinecoupling constants,
%          and magnetic moments (g-factors). A theoretical study.J. Mol.Spectrosc., 250(2):75–85, 2008

% a = 0;            %[MHz] - Use to turn off hyperfine doubling
% b = 0;            %[MHz] - Use to turn off hyperfine doubling
% c = 0;            %[MHz] - Use to turn off hyperfine doubling
% d = 0;            %[MHz] - Use to turn off hyperfine doubling

cl = 299792458;             %[m/s] speed of light
a = ((a*1e6)/cl)/100;       %[cm-1]
b = ((b*1e6)/cl)/100;       %[cm-1]
c = ((c*1e6)/cl)/100;       %[cm-1]
d = ((d*1e6)/cl)/100;       %[cm-1]
% T = (T*cl*100)*1e-6;
% B = B*cl*100*1e-6;
% D = D*cl*1e-4;
% A = A*cl*1e-4;
% AD = AD*cl*1e-4;
% p = p*cl*1e-4;
% q = q*cl*1e-4;
%% Meerts energy levels in terms of +/- parity

% Only J = 0, +-1 states mix
% Size of matrix.
% If J'' = 1/2, 3x3 matrix
% If J'' = 3/2, 5x5 matrix
% else 6x6

if (J_l == 1/2)
    index = 3;          % Size of matrix
elseif (J_l == 3/2)
    index = 5;          % Size of matrix
else
    index = 6;          % Size of matrix
end

H = zeros(index, index);
sp = zeros(index, index);

% In the case of J'' > 3/2, the 6x6 matrix is written as:


% <F1,J'=J_l-1|H|F1,J''=J_l-1>  <F1,J'=J_l-1|H|F1,J''=J_l>      <F1,J'=J_l-1|H|F1,J''=J_l+1>    <F1,J'=J_l-1|H|F2,J''=J_l-1>    <F1,J'=J_l-1|H|F2,J''=J_l>      <F1,J'=J_l-1|H|F2,J''=J_l+1>
% <F1,J'=J_l|H|F1,J''=J_l-1>    <F1,J'=J_l|H|F1,J''=J_l>        <F1,J'=J_l|H|F1,J''=J_l+1>      <F1,J'=J_l|H|F2,J''=J_l-1>      <F1,J'=J_l|H|F2,J''=J_l>        <F1,J'=J_l|H|F2,J''=J_l+1>
% <F1,J'=J_l+1|H|F1,J''=J_l-1>  <F1,J'=J_l+1|H|F1,J''=J_l>      <F1,J'=J_l+1|H|F1,J''=J_l+1>    <F1,J'=J_l+1|H|F2,J''=J_l-1>    <F1,J'=J_l+1|H|F2,J''=J_l>      <F1,J'=J_l+1|H|F2,J''=J_l+1>
% <F2,J'=J_l-1|H|F1,J''=J_l-1>  <F2,J'=J_l-1|H|F1,J''=J_l>      <F2,J'=J_l-1|H|F1,J''=J_l+1>    <F2,J'=J_l-1|H|F2,J''=J_l-1>    <F2,J'=J_l-1|H|F2,J''=J_l>      <F2,J'=J_l-1|H|F2,J''=J_l+1>
% <F2,J'=J_l|H|F1,J''=J_l-1>    <F2,J'=J_l|H|F1,J''=J_l>        <F2,J'=J_l|H|F1,J''=J_l+1>      <F2,J'=J_l|H|F2,J''=J_l-1>      <F2,J'=J_l|H|F2,J''=J_l>        <F2,J'=J_l|H|F2,J''=J_l+1>
% <F2,J'=J_l+1|H|F1,J''=J_l-1>  <F2,J'=J_l+1|H|F1,J''=J_l>      <F2,J'=J_l+1|H|F1,J''=J_l+1>    <F2,J'=J_l+1|H|F2,J''=J_l-1>    <F2,J'=J_l+1|H|F2,J''=J_l>      <F2,J'=J_l+1|H|F2,J''=J_l+1>

% Only negative parity states are calculated since only these were needed
% for our transitions

if(index == 6)                          % General case of J'' > 3/2
    
    for i = 1:1:index                   % Index for my bras <|
        for j = 1:1:index               % Index for my kets |>
            
            % J_j = J''
            % J_i = J'
            
            if ((i == 1)||(i ==4))
                J_i = J_l - 1;
            elseif ((i == 2)||(i == 5))
                J_i = J_l;
            elseif ((i == 3)||(i == 6))
                J_i = J_l + 1;
            end
            
            if ((j == 1)||(j ==4))
                J_j = J_l - 1;
            elseif ((j == 2)||(j == 5))
                J_j = J_l;
            elseif ((j == 3)||(j == 6))
                J_j = J_l + 1;
            end
            
            G = sqrt((2*J_j + 1)*(2*J_i + 1)*I*(I+1)*(2*I+1))...
                * (-1)^(J_j+I+F)*Wigner6j(F,J_j,I,1,I,J_i); % Hyperfine G factor
            %G = sqrt((2*J_j + 1)*(2*J_i + 1)*I*(I+1)*(2*I+1) )*(-1)^(J_i+I+F)*Wigner6j(F,J_j,I,1,I,J_i);
            sp(i,j) = G;
            % Hamiltonian defintions for the block forn [H11 H12; H21 H22]
            % were H11 = <F1|H|F1>, H12 = H21 = <F1|H|F2>, H22 = <F2|H|F2>
            
            if ((i<4)&&(j<4))
                H(i,j) = eq(J_i, J_j)*(T + A/2 + 0.5*AD*((J_i+1/2)^2-2) +...
                    B*((J_i+1/2)^2-2) - D*((J_i+1/2)^4 - 3*(J_i+1/2)^2 + 3) + 0) + ...
                    G*(-1)^(J_i-0.5)*Wigner3j([J_j 1 J_i], [-3/2 0 3/2])*(a+0.5*(b+c));
            elseif ((i<4)&&(j>=4))
                H(i,j) = eq(J_i, J_j)*( B*sqrt((J_i+1/2)^2 - 1) -...
                    2*D*((J_i+1/2)^2 - 1)*sqrt((J_i+1/2)^2 - 1) +...
                    (-1)^(J_j-0.5)*(J_j+0.5)*0.5*sqrt((J_i+1/2)^2 - 1)*q ) +...
                    G*(-1)^(J_i+0.5)*Wigner3j([J_j 1 J_i], [-3/2 1 1/2])*b/sqrt(2) ;
            elseif ((i>=4)&&(j<4))
                H(i,j) = eq(J_i, J_j)*( B*sqrt((J_i+1/2)^2 - 1) -...
                    2*D*((J_i+1/2)^2 - 1)*sqrt((J_i+1/2)^2 - 1) +...
                    (-1)^(J_j-0.5)*(J_j+0.5)*0.5*sqrt((J_i+1/2)^2 - 1)*q )+...
                    G*(-1)^(J_i+0.5)*Wigner3j([J_j 1 J_i], [-3/2 1 1/2])*b/sqrt(2);
            else
                H(i,j) = eq(J_i, J_j)*(T - A/2 - 0.5*AD*(J_i+1/2)^2 +...
                    B*(J_i+1/2)^2 -D*((J_i+1/2)^4 + (J_i+1/2)^2 - 1)+...
                    (-1)^(J_j-0.5)*(J_j+0.5)*(0.5*p+q) )+...
                    G*( (-1)^(J_i-0.5)*Wigner3j([J_j 1 J_i], [-1/2 0 1/2])*(a-0.5*(b+c)) -...
                    Wigner3j([J_j 1 J_i], [-1/2 1 -1/2])*d/sqrt(2) );
            end
        end
        
    end
    
    
    % In the case of J'' = 3/2, the 5x5 matrix is written as:
    
    
    % <F1,J'=J_l|H|F1,J''=J_l>        <F1,J'=J_l|H|F1,J''=J_l+1>      <F1,J'=J_l|H|F2,J''=J_l-1>      <F1,J'=J_l|H|F2,J''=J_l>        <F1,J'=J_l|H|F2,J''=J_l+1>
    % <F1,J'=J_l+1|H|F1,J''=J_l>      <F1,J'=J_l+1|H|F1,J''=J_l+1>    <F1,J'=J_l+1|H|F2,J''=J_l-1>    <F1,J'=J_l+1|H|F2,J''=J_l>      <F1,J'=J_l+1|H|F2,J''=J_l+1>
    % <F2,J'=J_l-1|H|F1,J''=J_l>      <F2,J'=J_l-1|H|F1,J''=J_l+1>    <F2,J'=J_l-1|H|F2,J''=J_l-1>    <F2,J'=J_l-1|H|F2,J''=J_l>      <F2,J'=J_l-1|H|F2,J''=J_l+1>
    % <F2,J'=J_l|H|F1,J''=J_l>        <F2,J'=J_l|H|F1,J''=J_l+1>      <F2,J'=J_l|H|F2,J''=J_l-1>      <F2,J'=J_l|H|F2,J''=J_l>        <F2,J'=J_l|H|F2,J''=J_l+1>
    % <F2,J'=J_l+1|H|F1,J''=J_l>      <F2,J'=J_l+1|H|F1,J''=J_l+1>    <F2,J'=J_l+1|H|F2,J''=J_l-1>    <F2,J'=J_l+1|H|F2,J''=J_l>      <F2,J'=J_l+1|H|F2,J''=J_l+1>
    
    % Only negative parity states are calculated since only these were needed
    % for our transitions
    
    
elseif (index ==5)
    
    for i = 1:1:index           % Index for my bras <|
        for j = 1:1:index       % Index for my kets |>
            
            if ((i == 3))
                J_i = J_l - 1;
            elseif ((i == 1)||(i == 4))
                J_i = J_l;
            elseif ((i == 2)||(i == 5))
                J_i = J_l + 1;
            end
            
            if ((j == 3))
                J_j = J_l - 1;
            elseif ((j == 1)||(j == 4))
                J_j = J_l;
            elseif ((j == 2)||(j == 5))
                J_j = J_l + 1;
            end
            
            G = sqrt((2*J_j + 1)*(2*J_i + 1)*I*(I+1)*(2*I+1) )*(-1)^(J_j+I+F)*Wigner6j(F,J_j,I,1,I,J_i);
            sp(i,j) = G;
            
            
            if ((i<3)&&(j<3))
                H(i,j) = eq(J_i, J_j)*(T + A/2 + 0.5*AD*((J_i+1/2)^2-2) +...
                    B*((J_i+1/2)^2-2) - D*((J_i+1/2)^4 - 3*(J_i+1/2)^2 + 3) + 0) + ...
                    G*(-1)^(J_i-0.5)*Wigner3j([J_j 1 J_i], [-3/2 0 3/2])*(a+0.5*(b+c));
            elseif ((i<3)&&(j>=3))
                H(i,j) = eq(J_i, J_j)*( B*sqrt((J_i+1/2)^2 - 1) -...
                    2*D*((J_i+1/2)^2 - 1)*sqrt((J_i+1/2)^2 - 1) +...
                    (-1)^(J_j-0.5)*(J_j+0.5)*0.5*sqrt((J_i+1/2)^2 - 1)*q ) +...
                    G*(-1)^(J_i+0.5)*Wigner3j([J_j 1 J_i], [-3/2 1 1/2])*b/sqrt(2) ;
            elseif ((i>=3)&&(j<3))
                H(i,j) = eq(J_i, J_j)*( B*sqrt((J_i+1/2)^2 - 1) -...
                    2*D*((J_i+1/2)^2 - 1)*sqrt((J_i+1/2)^2 - 1) +...
                    (-1)^(J_j-0.5)*(J_j+0.5)*0.5*sqrt((J_i+1/2)^2 - 1)*q )+...
                    G*(-1)^(J_i+0.5)*Wigner3j([J_j 1 J_i], [-3/2 1 1/2])*b/sqrt(2);
            else
                H(i,j) = eq(J_i, J_j)*(T - A/2 - 0.5*AD*(J_i+1/2)^2 +...
                    B*(J_i+1/2)^2 -D*((J_i+1/2)^4 + (J_i+1/2)^2 - 1)+...
                    (-1)^(J_j-0.5)*(J_j+0.5)*(0.5*p+q) )+...
                    G*( (-1)^(J_i-0.5)*Wigner3j([J_j 1 J_i], [-1/2 0 1/2])*(a-0.5*(b+c)) -...
                    Wigner3j([J_j 1 J_i], [-1/2 1 -1/2])*d/sqrt(2) );
            end
        end
        
    end
    
    % In the case of J'' = 1/2, the 3x3 matrix is written as:
    
    
    % <F1,J'=J_l+1|H|F1,J''=J_l+1>    <F1,J'=J_l+1|H|F2,J''=J_l>      <F1,J'=J_l+1|H|F2,J''=J_l+1>
    % <F2,J'=J_l|H|F1,J''=J_l+1>      <F2,J'=J_l|H|F2,J''=J_l>        <F2,J'=J_l|H|F2,J''=J_l+1>
    % <F2,J'=J_l+1|H|F1,J''=J_l+1>    <F2,J'=J_l+1|H|F2,J''=J_l>      <F2,J'=J_l+1|H|F2,J''=J_l+1>
    
    % Only negative parity states are calculated since only these were needed
    % for our transitions
    
    
    
elseif (index == 3)
    for i = 1:1:index % Index for my kets
        for j = 1:1:index % Index for my kets
            
            if ((i == 1))
                J_i = J_l + 1;
            elseif ((i == 2))
                J_i = J_l;
            elseif ((i == 3))
                J_i = J_l + 1;
            end
            
            if ((j == 1))
                J_j = J_l + 1;
            elseif ((j == 2))
                J_j = J_l;
            elseif ((j == 3))
                J_j = J_l + 1;
            end
            
            G = sqrt((2*J_j + 1)*(2*J_i + 1)*I*(I+1)*(2*I+1) )*(-1)^(J_j+I+F)*Wigner6j(F,J_j,I,1,I,J_i);
            sp(i,j) = G;
            
            if ((i<2)&&(j<2))
                H(i,j) = eq(J_i, J_j)*(T + A/2 + 0.5*AD*((J_i+1/2)^2-2) +...
                    B*((J_i+1/2)^2-2) - D*((J_i+1/2)^4 - 3*(J_i+1/2)^2 + 3) + 0) + ...
                    G*(-1)^(J_i-0.5)*Wigner3j([J_j 1 J_i], [-3/2 0 3/2])*(a+0.5*(b+c));
            elseif ((i<2)&&(j>=2))
                H(i,j) = eq(J_i, J_j)*( B*sqrt((J_i+1/2)^2 - 1) -...
                    2*D*((J_i+1/2)^2 - 1)*sqrt((J_i+1/2)^2 - 1) +...
                    (-1)^(J_j-0.5)*(J_j+0.5)*0.5*sqrt((J_i+1/2)^2 - 1)*q ) +...
                    G*(-1)^(J_i+0.5)*Wigner3j([J_j 1 J_i], [-3/2 1 1/2])*b/sqrt(2) ;
            elseif ((i>=2)&&(j<2))
                H(i,j) = eq(J_i, J_j)*( B*sqrt((J_i+1/2)^2 - 1) -...
                    2*D*((J_i+1/2)^2 - 1)*sqrt((J_i+1/2)^2 - 1) +...
                    (-1)^(J_j-0.5)*(J_j+0.5)*0.5*sqrt((J_i+1/2)^2 - 1)*q )+...
                    G*(-1)^(J_i+0.5)*Wigner3j([J_j 1 J_i], [-3/2 1 1/2])*b/sqrt(2);
            else
                H(i,j) = eq(J_i, J_j)*(T - A/2 - 0.5*AD*(J_i+1/2)^2 +...
                    B*(J_i+1/2)^2 -D*((J_i+1/2)^4 + (J_i+1/2)^2 - 1)+...
                    (-1)^(J_j-0.5)*(J_j+0.5)*(0.5*p+q) )+...
                    G*( (-1)^(J_i-0.5)*Wigner3j([J_j 1 J_i], [-1/2 0 1/2])*(a-0.5*(b+c)) -...
                    Wigner3j([J_j 1 J_i], [-1/2 1 -1/2])*d/sqrt(2) );
            end
        end
        
    end
end

%disp(H);
[V, D] = eig(H);
[d,ind] = sort(diag(D));
Ds = D(ind,ind);
Vs = V(:,ind);
V = Vs;
D = Ds;
indices = find(abs(V)<1e-12);  % Ignore very small contributions (often  numerical artifacts)
V(indices) = 0;

if (disp_flag == 1)
    disp('---------- For A State ---------------');
end

if ((size(D,1) == 6)&&(Fn_A == 1))
    E_total = D(2,2);
    V_total = V(:,2);
    if (disp_flag == 1)
        disp(['Energy of F1, J = ', num2str(J_l*2), '/2 state is: ', num2str(E_total*100*cl/1e12), ' THz']);
        disp('Mixing coefficients');
        disp(['With F1, J = ', num2str((J_l-1)*2), '/2 : ', num2str(V_total(1))]);
        disp(['With F1, J = ', num2str((J_l)*2), '/2 : ', num2str(V_total(2))]);
        disp(['With F1, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(3))]);
        disp(['With F2, J = ', num2str((J_l-1)*2), '/2 : ', num2str(V_total(4))]);
        disp(['With F2, J = ', num2str((J_l)*2), '/2 : ', num2str(V_total(5))]);
        disp(['With F2, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(6))]);
    end
elseif ((size(D,1) == 6)&&(Fn_A == 2))
    E_total = D(5,5);
    V_total = V(:,5);
    if (disp_flag == 1)
        disp(['Energy of F2, J = ', num2str(J_l*2), '/2 state is: ', num2str(E_total*100*cl/1e12), ' THz']);
        disp('Mixing coefficients');
        disp(['With F1, J = ', num2str((J_l-1)*2), '/2 : ', num2str(V_total(1))]);
        disp(['With F1, J = ', num2str((J_l)*2), '/2 : ', num2str(V_total(2))]);
        disp(['With F1, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(3))]);
        disp(['With F2, J = ', num2str((J_l-1)*2), '/2 : ', num2str(V_total(4))]);
        disp(['With F2, J = ', num2str((J_l)*2), '/2 : ', num2str(V_total(5))]);
        disp(['With F2, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(6))]);
    end
elseif ((size(D,1) == 5)&&(Fn_A == 1))
    E_total = D(1,1);
    V_total = V(:,1);
    if (disp_flag == 1)
        disp(['Energy of F1, J = ', num2str(J_l*2), '/2 state is: ', num2str(E_total*100*cl/1e12), ' THz']);
        disp('Mixing coefficients');
        disp(['With F1, J = ', num2str((J_l)*2), '/2 : ', num2str(V_total(1))]);
        disp(['With F1, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(2))]);
        disp(['With F2, J = ', num2str((J_l-1)*2), '/2 : ', num2str(V_total(3))]);
        disp(['With F2, J = ', num2str((J_l)*2), '/2 : ', num2str(V_total(4))]);
        disp(['With F2, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(5))]);
    end
elseif ((size(D,1) == 5)&&(Fn_A == 2))
    E_total = D(4,4);
    V_total = V(:,4);
    if (disp_flag == 1)
        disp(['Energy of F2, J = ', num2str(J_l*2), '/2 state is: ', num2str(E_total*100*cl/1e12), ' THz']);
        disp('Mixing coefficients');
        disp(['With F1, J = ', num2str((J_l)*2), '/2 : ', num2str(V_total(1))]);
        disp(['With F1, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(2))]);
        disp(['With F2, J = ', num2str((J_l-1)*2), '/2 : ', num2str(V_total(3))]);
        disp(['With F2, J = ', num2str((J_l)*2), '/2 : ', num2str(V_total(4))]);
        disp(['With F2, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(5))]);
    end
elseif ((size(D,1) == 3)&&(Fn_A == 2))
    
    E_total = D(2,2);
    V_total = V(:,2);
    if (disp_flag == 1)
        disp(['Energy of F2, J = ', num2str(J_l*2), '/2 state is: ', num2str(E_total*100*cl/1e12), ' THz']);
        disp('Mixing coefficients');
        disp(['With F1, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(1))]);
        disp(['With F2, J = ', num2str((J_l)*2), '/2 : ', num2str(V_total(2))]);
        disp(['With F2, J = ', num2str((J_l+1)*2), '/2 : ', num2str(V_total(3))]);
    end
else
    disp('Error. Check the transition');
end



end
